function [xr, totalBits] = filterBanks8(x, h, g, Fs, bits, f, thres, FFTLength, totalBits)

% passes the received audio frame through the analysis filter bank,
% quantizes the result and then reconstructs the signal through the
% synthesis filter bank

% set number of filters and filter length
[M,L] = size(h);

convLength = L + length(x) - 1;

v = zeros(M,convLength);            % stores filter bank outputs
y = zeros(M,floor(length(v)/M));    % stores outputs decimated by M
wo = zeros(M,M*length(y));          % stores up-sampled signal after quantization
xr = zeros(1,L + M*length(y) - 1);  % stores reconstruction

% for each filter...
for k = 1:M  
      
   % calculate outputs of filter bank
   v(k,:) = conv(h(k,:),x);
        
   % decimate outputs by M
   for n = 1:floor(convLength/M)
	   y(k,n) = v(k,M*n);   
   end   
   
   % quantize the signal according to the psychoacoustic model
   [y(k,:), totalBits] = performEncoding(y(k,:), Fs, bits, FFTLength, M, f, k, thres, totalBits);
   
   % upsample outputs
   for n = 1:convLength
      if (mod(n,M) == 0)
         wo(k,n) = y(k,ceil(n/M));  % create step function/first-order hold   
      end      
   end   
   
   % reconstruct original signal from synthesis filters
   temp = conv(g(k,:),wo(k,:));
   lTemp = length(temp);
   xr(1,1:lTemp) = xr(1,1:lTemp) + temp;
end

% remove excessive zeros

epsilon = 1e-4;%0.01;
z = find(xr(1:length(xr)/2 > epsilon));
s = min(z);
if (isempty(s))
   s = 1;
end
e = s + FFTLength - 1;
if (e > length(xr))
   e = length(xr);
end
xr = xr(s:e);   
   